
#ifndef CRYS_SST_TST_ATP_ASYM_H
#define CRYS_SST_TST_ATP_ASYM_H

#if TST_USE_CRYS_SST_ASYM_MODULE

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:06:34 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SST_TST_ATP_Asym.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/*Authenticator test struct*/

/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_SST_TST_ATP_RSA
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *    Test the connection between CRYS and the SSTfunctionality while using SST RSA generated keys
 *    in the CRYS_SST module
 * 
 * Algorithm:       
 *    1.    Create a new session by calling: SST_SessionCreate.
 *    2.    Open a transaction by calling: SST_TransactionStart.
 *    3.    Generate RSA key Pair inside the SST by calling: CRYS_SST_RSA_KG_GenerateKeyPair.
 *    4.    Generate RSA CRT key Pair inside the SST by calling: CRYS_SST_RSA_KG_GenerateKeyPairCRT.
 *    5.    Read the RSA Public Key from the SST by calling: SST_RSAPublicKeyRead.
 *    6.    Read the RSA Public CRT Key from the SST by calling: SST_CRTRSAPublicKeyRead.
 *    7.    Build the RSA public key for CRYS usage by calling: CRYS_RSA_Build_PubKey
 *    8.    Build the RSA CRT public key for CRYS usage by calling: CRYS_RSA_Build_PubKey
 *    9.    Sign the data using the SST RSA key by calling: CRYS_SST_RSA_PKCS1v15_Sign.
 *    10.   Sign the data using the SST CRT RSA key by calling: CRYS_SST_RSA_PSS_Sign.
 *    11.   Verify the data signed by the RSA key by calling: CRYS_RSA_PKCS1v15_Verify
 *    12.    Verify the data signed by the RSA CRT key by calling: CRYS_RSA_PSS_Verify
 *    13.  Delete the RSA keys by calling: SST_DataDelete.
 *    14.  Close the authenticator by calling: SST_AuthenticationClose.
 *    15.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    16.  Close the transaction by calling: SST_TransactionClose.
 *    17.  Delete the session by calling: SST_SessionDelete.
 *                                
 *******************************************************************************/     
DxError_t CRYS_SST_TST_ATP_RSA ( void );

/* Function Name:                                                           
  *   CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  *    Test the CRYS_SST functions CRYS_SST_RSA_OAEP_Encrypt and CRYS_SST_RSA_OAEP_Decrypt
  * 
  * Algorithm:       
  *    1.    Create a new session by calling: SST_SessionCreate.
  *    2.    Open a transaction by calling: SST_TransactionStart.
  *    3.    Generate RSA key Pair inside the SST by calling: CRYS_SST_RSA_KG_GenerateKeyPair.
  *    4.    Encrypt the input buffer by calling CRYS_SST_RSA_OAEP_Encrypt. 
  *    5.    Decrypt the encrypted input buffer by calling CRYS_SST_RSA_OAEP_Decrypt . 
  *    6.    Verify decrypted buffer equals the input buffer.
  *    7.    Delete key.
  *    8.    Close the transaction by calling: SST_TransactionClose.
  *    9.    Delete the session by calling: SST_SessionDelete.
  *                                              
  *******************************************************************************/     
  DxError_t CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_SST_TST_ATP_RSA
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *    Test the connection between CRYS and the SSTfunctionality while using SST RSA generated keys
 *    in the CRYS_SST module
 *  
 * Algorithm:       
 *    1.    Create a new session by calling: SST_SessionCreate.
 *    2.    Open a transaction by calling: SST_TransactionStart.
 *    3.    Generate RSA key Pair inside the SST by calling: CRYS_SST_RSA_KG_GenerateKeyPair.
 *    5.    Read the RSA Public Key from the SST by calling: SST_RSAPublicKeyRead. 
 *    6.    Build the RSA public key for CRYS usage by calling: CRYS_RSA_Build_PubKey 
 *    7.    Encrypt the data using the CRYS RSA key by calling: CRYS_RSA_PRIM_Encrypt.
 *    8.    Decrypt the data using the SST RSA key by calling: CRYS_SST_RSA_PRIM_Decrypt.
 *    9.  Delete the RSA key by calling: SST_DataDelete.
 *    10.  Close the authenticator by calling: SST_AuthenticationClose.
 *    11.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    12.  Close the transaction by calling: SST_TransactionClose.
 *    13.  Delete the session by calling: SST_SessionDelete.
 *                                
 *******************************************************************************/
DxError_t CRYS_SST_TST_ATP_RSA_Prim ( void );


#ifdef __cplusplus
}
#endif

#endif

#endif



